/******************************************************************************
 * (C) Copyright 2000 by Agilent Technologies GmbH. All rights reserved.      *
 ******************************************************************************/

/* ---------------------------------------------------------------
 * File: seqdefs.h 
 *       sequencer definitions
 *       This file is included in CAPI and Firmware !!     
 * -----------------------------------------------------------------*/

#ifndef XSEQUDEFS_H_INCLUDED
#define XSEQUDEFS_H_INCLUDED

/* Number of Sequencers */
#define BX_TRIGSEQ_SIZE 1 /* one  Trigger sequencer       */
#define BX_PERFSEQ_SIZE 4 /* four Performance sequencers for 2nd cut */

#define BX_PERFSEQ_SIZE_MMC1_MMC2 2 /* two Performance sequencers (MMC1 and MMC2) */
/* this enums distinguishes the different sequencers the parser can handle */
/* #define BX_SEQUENCER_SIZE (BX_TRIGSEQ_SIZE+BX_PERFSEQ_SIZE) not in use ? MR */
typedef enum 
{
  BX_SEQ_TRIG,          
  BX_SEQ_PERF_0,          
  BX_SEQ_PERF_1,
  BX_SEQ_PERF_2,
  BX_SEQ_PERF_3,
  BX_SEQ_INVALID = 255          
} bx_seqtype;

#endif
